<?php

declare(strict_types=1);

namespace Tests\Class\EbayOrderSteps;

use MZoldak\EbayOrdersImport\Class\CSVDataProcessor;
use PHPUnit\Framework\TestCase;

/**
 * @internal
 *
 * @covers \MZoldak\EbayOrdersImport\Class\CSVDataProcessor
 */
class CSVDataProcessorTest extends TestCase {
    public function testProperDataLoading() {
        $csvDataProcessor = new CSVDataProcessor(__DIR__.'/../../data/ebay_orders_import_2024_MARCH.csv');
        $data = $csvDataProcessor->getData();
        $headers = $csvDataProcessor->getHeaders();

        // $this->assertTrue(4 == count($data));
        // $this->assertTrue(79 == count($headers));
        $this->assertSameSize($headers, $data[0]);

        $firstRow = $data[0];

        $dateFromCsv = date('d-M-y', $firstRow['Verkauft am']);

        $this->assertEquals($dateFromCsv, '01-Mär-24');
        $this->assertEquals($firstRow['Verkauft für'], 79.95);
        $this->assertEquals($firstRow['Inklusive MwSt.-Satz'], 19.00);
    }
}
