<?php

declare(strict_types=1);

namespace MZoldak\EbayOrdersImport\Twig;

use Twig\Extension\AbstractExtension;

class EbayExtension extends AbstractExtension {
    public function getFilters(): array {
        return [
            new \Twig\TwigFilter('translateEbayKey', [$this, 'translateEbayKey']),
            new \Twig\TwigFilter('ebayKeyRequired', [$this, 'ebayKeyRequired']),
        ];
    }

    public function translateEbayKey(string $key): string {
        return match ($key) {
            'ebay_order_number' => 'Bestellnummer',
            'ebay_sales_record_number' => 'Verkaufsprotokollnummer',
            'delivery_price' => 'Versandpreis',
            'tax' => 'MwSt.',
            'quantity' => 'Anzahl',
            'unit_price' => 'Stückpreis',
            'offer_title' => 'Angebotstitel',
            default => $key,
        };
    }

    public function ebayKeyRequired(string $key): bool {
        switch ($key) {
            case 'ebay_order_number':
            case 'ebay_sales_record_number':
            case 'quantity':
            case 'name':
            case 'tax':
            case 'unit_price':
                return true;
            default:
                return false;
        }
    }
}
