<?php

declare(strict_types=1);

namespace MZoldak\EbayOrdersImport\Service;

use MZoldak\EbayOrdersImport\Class\FieldsMappingExportImport;

class CSVFieldName {
    private static array $fieldsMapping;

    public static function initialize() {
        self::$fieldsMapping = FieldsMappingExportImport::load();
    }

    public static function recordSalesNumber(): string {
        return self::$fieldsMapping['order']['ebay_sales_record_number'] ?? '';
    }

    public static function ebayClient(): string {
        return self::$fieldsMapping['order']['ebay_client'] ?? '';
    }

    public static function orderLocked(): string {
        return self::$fieldsMapping['order']['locked'] ?? '';
    }

    public static function orderDatePaid(): string {
        return self::$fieldsMapping['order']['date_paid'] ?? '';
    }

    public static function orderTotal(): string {
        return self::$fieldsMapping['order']['total'] ?? '';
    }

    public static function orderSalesRecordNumber(): string {
        return self::$fieldsMapping['order']['ebay_sales_record_number'] ?? '';
    }

    public static function orderNumber(): string {
        return self::$fieldsMapping['order']['ebay_order_number'] ?? '';
    }

    public static function orderDeliveryPrice(): string {
        return self::$fieldsMapping['order']['delivery_price'] ?? '';
    }

    public static function username(): string {
        return self::$fieldsMapping['member']['ebay_username'] ?? '';
    }

    public static function ebayClientEmail(): string {
        return self::$fieldsMapping['member']['ebay_client_email'] ?? '';
    }

    public static function memberFullname(): string {
        return self::$fieldsMapping['member']['firstname'] ?? '';
    }

    public static function memberEmail(): string {
        return self::$fieldsMapping['member']['email'] ?? '';
    }

    public static function memberPhone(): string {
        return self::$fieldsMapping['member']['phone'] ?? '';
    }

    public static function productSku(): string {
        return self::$fieldsMapping['product']['sku'] ?? '';
    }

    public static function offerTitle(): string {
        return self::$fieldsMapping['product']['offer_title'] ?? '';
    }

    public static function piecePrice(): string {
        return self::$fieldsMapping['product']['unit_price'] ?? '';
    }

    public static function productQuantity(): string {
        return self::$fieldsMapping['product']['quantity'] ?? '';
    }

    public static function productTaxRate(): string {
        return self::$fieldsMapping['product']['tax'] ?? '';
    }

    public static function shippingAddressFullname(): string {
        return self::$fieldsMapping['shipping_address']['firstname'] ?? '';
    }

    public static function shippingAddressStreet1(): string {
        return self::$fieldsMapping['shipping_address']['street_1'] ?? '';
    }

    public static function shippingAddressStreet2(): string {
        return self::$fieldsMapping['shipping_address']['street_2'] ?? '';
    }

    public static function shippingAddressStreet3(): string {
        return self::$fieldsMapping['shipping_address']['street_3'] ?? '';
    }

    public static function shippingAddressPostal(): string {
        return self::$fieldsMapping['shipping_address']['postal'] ?? '';
    }

    public static function shippingAddressCity(): string {
        return self::$fieldsMapping['shipping_address']['city'] ?? '';
    }

    public static function shippingAddressCountry(): string {
        return self::$fieldsMapping['shipping_address']['country'] ?? '';
    }

    public static function shippingAddressPhone(): string {
        return self::$fieldsMapping['shipping_address']['phone'] ?? '';
    }

    public static function shippingAddressEmail(): string {
        return self::$fieldsMapping['shipping_address']['email'] ?? '';
    }

    public static function billingAddressFullname(): string {
        return self::$fieldsMapping['billing_address']['firstname'] ?? '';
    }

    public static function billingAddressStreet1(): string {
        return self::$fieldsMapping['billing_address']['street_1'] ?? '';
    }

    public static function billingAddressStreet2(): string {
        return self::$fieldsMapping['billing_address']['street_2'] ?? '';
    }

    public static function billingAddressStreet3(): string {
        return self::$fieldsMapping['billing_address']['street_3'] ?? '';
    }

    public static function billingAddressPostal(): string {
        return self::$fieldsMapping['billing_address']['postal'] ?? '';
    }

    public static function billingAddressCity(): string {
        return self::$fieldsMapping['billing_address']['city'] ?? '';
    }

    public static function billingAddressCountry(): string {
        return self::$fieldsMapping['billing_address']['country'] ?? '';
    }

    public static function billingAddressPhone(): string {
        return self::$fieldsMapping['billing_address']['phone'] ?? '';
    }

    public static function billingAddressEmail(): string {
        return self::$fieldsMapping['billing_address']['email'] ?? '';
    }
}
