<?php

declare(strict_types=1);

namespace MZoldak\EbayOrdersImport\EventListener;

use Contao\CoreBundle\Event\ContaoCoreEvents;
use Contao\CoreBundle\Event\MenuEvent;
use MZoldak\EbayOrdersImport\Controller\EbayOrdersImportController;
use Symfony\Component\EventDispatcher\Attribute\AsEventListener;
use Symfony\Component\HttpFoundation\RequestStack;
use Symfony\Component\Routing\RouterInterface;

#[AsEventListener(ContaoCoreEvents::BACKEND_MENU_BUILD)]
class BackendMenuListener {
    protected $router;
    protected $requestStack;

    public function __construct(RouterInterface $router, RequestStack $requestStack) {
        $this->router = $router;
        $this->requestStack = $requestStack;
    }

    public function __invoke(MenuEvent $event): void {
        $factory = $event->getFactory();
        $tree = $event->getTree();

        if ('mainMenu' !== $tree->getName()) {
            return;
        }

        $isotopeNode = $tree->getChild('isotope');

        $node = $factory
            ->createItem('ebay-orders-import')
            ->setUri($this->router->generate(EbayOrdersImportController::class.'_main'))
            ->setLabel('Import Ebay Bestellungen')
            ->setLinkAttribute('title', 'Title')
            ->setLinkAttribute('class', 'ebay-orders-import')
            ->setCurrent(EbayOrdersImportController::class === $this->requestStack->getCurrentRequest()->get('_controller'))
        ;

        $isotopeNode->addChild($node);
    }
}
