<?php

declare(strict_types=1);

namespace MZoldak\EbayOrdersImport\Controller;

use App\Class\Isotope\Order\OrderManipulator;
use App\EventListener\Isotope\ProductCollection\ShippingMethodOnSaveListener;
use App\Services\CallbackSubscriber;
use Contao\CoreBundle\Controller\AbstractController;
use Contao\CoreBundle\Csrf\ContaoCsrfTokenManager;
use Contao\System;
use Isotope\Model\ProductCollection;
use Isotope\Model\ProductCollection\Order;
use MZoldak\EbayOrdersImport\Controller\EbayOrdersImport\Import;
use MZoldak\EbayOrdersImport\Controller\EbayOrdersImport\ImportOptions;
use MZoldak\EbayOrdersImport\Controller\EbayOrdersImport\ImportPreview;
use MZoldak\EbayOrdersImport\Service\CSVFieldName;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;

#[Route('%contao.backend.route_prefix%/ebay', name: self::class, defaults: ['_scope' => 'backend'])]
class EbayOrdersImportController extends AbstractController {
    private string $csrfToken;

    public function __construct(ContaoCsrfTokenManager $csrfTokenManager) {
        $this->csrfToken = $csrfTokenManager->getDefaultTokenValue();
    }

    #[Route('/main', name: '_main')]
    public function step1() {
        return $this->render('@EbayOrdersImport/fileInput.html.twig', [
            'request_token' => $this->csrfToken,
        ]);
    }

    #[Route('/import-options', name: '_import-options')]
    public function step2(Request $request) {
        $importOptionsView = new ImportOptions($request);

        return $this->render('@EbayOrdersImport/importOptions.html.twig',
            [
                'form_action' => '/contao/ebay/import-preview',
                'request_token' => $this->csrfToken,
                ...$importOptionsView->run(),
            ]
        );
    }

    #[Route('/import-preview', name: '_import-preview')]
    public function step3(Request $request) {
        $importPreview = new ImportPreview($request);

        return $this->render('@EbayOrdersImport/importPreview.html.twig',
            [
                'form_action' => '/contao/ebay/import-summary',
                'request_token' => $this->csrfToken,
                ...$importPreview->run(),
            ]
        );
    }

    #[Route('/import-summary', name: '_import-summary')]
    public function step4(Request $request) {
        CSVFieldName::initialize();
        $import = new Import($request);
        $createdOrders = array_filter($import->run());

        return $this->redirect('/contao/ebay/independ-update?ids=' . implode(',', $createdOrders));
    }

    #[Route('/independ-update', name: '_independ-update')]
    public function step5(Request $request) {
        $ids = $request->query->get('ids');
        $orderIds = explode(',', $ids);
        $orders = @Order::findMultipleByIds($orderIds);
        $om = new OrderManipulator();
        foreach ($orders as $order){
            invade($order)->clearCache();
            // dump($order);
            $om->synchroniseAll($order);
        }
        // dd();
        
        return $this->render('@EbayOrdersImport/importSummary.html.twig');
    }
}
