<?php

declare(strict_types=1);

namespace MZoldak\EbayOrdersImport\Controller\EbayOrdersImport;

use Isotope\Model\ProductCollection;
use MZoldak\EbayOrdersImport\Class\FEDataSorter;
use MZoldak\EbayOrdersImport\Class\FieldsMappingExportImport;
use MZoldak\EbayOrdersImport\Contants\Ebay;
use MZoldak\EbayOrdersImport\Interface\EbayOrderImportStep;
use MZoldak\EbayOrdersImport\Service\CSVFieldName;
use Symfony\Component\HttpFoundation\Request;

class ImportPreview implements EbayOrderImportStep {
    private array $formData;

    public function __construct(private Request $request) {
        $this->formData = $this->request->request->all();
    }

    public function run(): array {
        (new FieldsMappingExportImport())->save($this->formData);

        CSVFieldName::initialize();

        $csvData = json_decode($this->formData['csv_data'], true);

        $sortedData = FEDataSorter::sort($csvData);
        
        return [
            'existing_members' => $sortedData['existingMembers'],
            'new_members' => $sortedData['membersToCreate'],
            'existing_orders' => $sortedData['existingOrders'],
            'new_orders' => $sortedData['ordersToCreate'],
            'users_assigned_orders' => $sortedData['usersAssignedOrders'],
            'csv_data' => $csvData,
            'csv_headers' => json_decode($this->formData['csv_headers']),
        ];
    }
}
