<?php

declare(strict_types=1);

namespace MZoldak\EbayOrdersImport\Controller\EbayOrdersImport;

use MZoldak\EbayOrdersImport\Class\FEDataSorter;
use MZoldak\EbayOrdersImport\Class\Importers\Importer;
use MZoldak\EbayOrdersImport\Interface\EbayOrderImportStep;
use MZoldak\EbayOrdersImport\Service\CSVFieldName;
use Symfony\Component\HttpFoundation\Request;

class Import implements EbayOrderImportStep {
    private array $csvData;
    private array $data;

    public function __construct(private Request $request) {
        $postData = $this->request->request->all();
        $this->csvData = json_decode($postData['csv_data'], true);
        $this->data = FEDataSorter::sort($this->csvData);
    }

    public function run(): array {

        $createdOrders = [];

        foreach ($this->data['usersAssignedOrders'] as $ebayClient => $orders) {         
            $csvOrders = array_reduce($this->csvData, function ($carry, $row) use ($ebayClient) {
                if ($row[CSVFieldName::username()] === $ebayClient) {
                    $carry[$row[CSVFieldName::orderSalesRecordNumber()]][] = $row;
                }

                return $carry;
            }, []);
            
            $importer = new Importer($ebayClient, $orders, $csvOrders);
            array_push($createdOrders, ...$importer->importData());
        }

        return $createdOrders;
    }
}
