<?php

namespace MZoldak\EbayOrdersImport\ContaoManager;

use Contao\CoreBundle\ContaoCoreBundle;
use Contao\ManagerPlugin\Bundle\BundlePluginInterface;
use Contao\ManagerPlugin\Bundle\Config\BundleConfig;
use Contao\ManagerPlugin\Bundle\Parser\ParserInterface;
use Contao\ManagerPlugin\Routing\RoutingPluginInterface;
use MZoldak\EbayOrdersImport\EbayOrdersImport;
use Symfony\Component\Config\Loader\LoaderResolverInterface;
use Symfony\Component\HttpKernel\KernelInterface;

class Plugin implements BundlePluginInterface, RoutingPluginInterface {

    public function getBundles(ParserInterface $parser): array {
        return [
            BundleConfig::create(EbayOrdersImport::class)
                ->setLoadAfter([ContaoCoreBundle::class, 'isotope']),
        ];
    }

    public function getRouteCollection(LoaderResolverInterface $resolver, KernelInterface $kernel) {
        $file = __DIR__ . '/../Resources/config/routes.yaml';
        return $resolver->resolve($file)->load($file);
    }
}
