<?php

declare(strict_types=1);

namespace MZoldak\EbayOrdersImport\Class\Importers;

use Contao\MemberModel;
use MZoldak\EbayOrdersImport\Service\CSVFieldName;

class MemberImporter {
    public function __construct(private string $ebayUsername, private array $orderData) {
    }

    public function importData() {
        return $this->loadMember();
    }

    private function loadMember(): MemberModel {
        $member = MemberModel::findOneBy('ebay_username', $this->ebayUsername);

        if (!$member) {
            $member = $this->createMember();
        }

        return $member;
    }

    private function createMember() {
        $name = explode(' ', $this->orderData[CSVFieldName::memberFullname()]);

        $member = new MemberModel();
        $member->tstamp = time();
        $member->dateAdded = time();
        $member->ebay_username = $this->ebayUsername;
        $member->firstname = array_shift($name) ?? '';
        $member->lastname = implode(" ", $name) ?? '';
        $member->email = $this->orderData[CSVFieldName::memberEmail()] ?? '';
        $member->phone = $this->orderData[CSVFieldName::memberPhone()] ?? '';
        $member->save();

        return $member;
    }
}
