<?php

declare(strict_types=1);

namespace MZoldak\EbayOrdersImport\Class\Importers;

class Importer {
    public function __construct(
        private string $ebayUsername,
        private array $orders,
        private array $csvOrders,
    ) {
        $this->csvOrders = $csvOrders;
    }

    public function importData() {
        $member = (new MemberImporter($this->ebayUsername, $this->csvOrders[array_key_first($this->csvOrders)][0]))->importData();
        $orderImporter = new OrdersImporter($member, $this->orders, $this->csvOrders);

        return $orderImporter->importData();
    }
}
