<?php

declare(strict_types=1);

namespace MZoldak\EbayOrdersImport\Class;

use Contao\System;

class FieldsMappingExportImport {
    public static $path;
    private static $fieldsMapping;

    public static function load(): array {
        self::initialize();

        if (!empty(self::$fieldsMapping)) {
            return self::$fieldsMapping;
        }

        self::$fieldsMapping = json_decode(file_get_contents(self::$path), true);

        return self::$fieldsMapping;
    }

    public static function save(array $data) {
        if (empty($data)) {
            return;
        }

        self::initialize();

        $fieldsMappingPath = self::$path;

        unset($data['REQUEST_TOKEN'], $data['csv_data'], $data['csv_headers'], $data['fieldsMappingPath']);

        $json = json_encode($data, JSON_PRETTY_PRINT);

        file_put_contents($fieldsMappingPath, $json);
    }

    private static function initialize() {
        $ebayDir = System::getContainer()->getParameter('kernel.project_dir').'/var/ebay';
        if (!is_dir($ebayDir)) {
            mkdir($ebayDir);
        }

        if (!file_exists($ebayDir.'/import_selection.json')) {
            file_put_contents($ebayDir.'/import_selection.json', json_encode([]));
        }

        if (empty(self::$path)) {
            self::$path = realpath($ebayDir.'/import_selection.json');
        }
    }
}
