<?php

declare(strict_types=1);

namespace MZoldak\EbayOrdersImport\Class\EbayModelKeysFilters;

use Contao\Model;

abstract class AbstractModelKeyFilter {
    private static array $instances = [];

    private function __construct() {
    }

    public static function getInstance(string $table): AbstractModelKeyFilter {
        if (!isset(self::$instances[$table])) {
            self::$instances[$table] = self::createInstance($table);
        }

        return self::$instances[$table];
    }

    public function getAdditionalKeys(): array {
        return [];
    }

    public function isNecessary(string $field): bool {
        return in_array($field, $this->necessaryFields($field));
    }

    private static function createInstance(string $table): AbstractModelKeyFilter {
        return match ($table) {
            'tl_iso_product_collection' => new OrderKeyFilter(),
            'tl_member' => new MemberKeyFilter(),
            'tl_iso_address' => new AddressKeyFilter(),
            'tl_iso_product' => new ProductKeyFilter(),
            default => throw new \Error('No filter implemented for this model'),
        };
    }

    abstract protected function necessaryFields(): array;
}
