<?php

declare(strict_types=1);

namespace MZoldak\EbayOrdersImport\Class;

use Contao\Database;
use Contao\Model;
use Doctrine\DBAL\Schema\Schema;
use MZoldak\EbayOrdersImport\Class\EbayModelKeysFilters\AbstractModelKeyFilter;

class EbayFieldsKeysFilter {
    public static function getKeys(string $table): array {
        $db = Database::getInstance();
        $fields = $db->getFieldNames($table);
        
        $filter = AbstractModelKeyFilter::getInstance($table);

        $modelKeys = self::filterModelKeys($fields, $filter);
        $additionalKeys = $filter->getAdditionalKeys();

        return array_merge($modelKeys, $additionalKeys);
    }

    private static function filterModelKeys(array $fields, AbstractModelKeyFilter $filter): array {
        return array_filter($fields, function ($field) use ($filter) {
            return $filter->isNecessary($field);
        });
    }
}
